/*
 * Decompiled with CFR 0.152.
 */
package feenamiditweaker;

import feenamiditweaker.FeenaDevice;
import feenamiditweaker.FrontPanel;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;

public class FrontPanelControl
extends JComponent
implements MouseListener {
    private int m_ID;
    FeenaDevice.Control m_Control;

    public FrontPanelControl(int id, int x, int y, int dx, int dy) {
        this.m_ID = id;
        this.m_Control = FeenaDevice.getInstance().getControlData(id);
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.setBackground(null);
        this.translateLocation(x, y, dx, dy);
        this.synchronizeWithDevice();
        this.addMouseListener(this);
    }

    public int getID() {
        return this.m_ID;
    }

    private void setID(int id) {
        this.m_ID = id;
    }

    public int getChannel() {
        return this.m_Control.getChannel();
    }

    public void setChannel(int ch) {
        this.m_Control.setChannel(ch);
        this.updateToolTip();
    }

    public void setInvert(boolean onOff) {
        this.m_Control.setInvert(onOff);
        this.updateToolTip();
    }

    public boolean getInvert() {
        return this.m_Control.getInvert();
    }

    public int getControlNum() {
        return this.m_Control.getControlNum();
    }

    public void setControlNum(int cnum) {
        this.m_Control.setControlNum(cnum);
        this.updateToolTip();
    }

    public int getControlType() {
        return this.m_Control.getControlType();
    }

    public void setControlType(int ctype) {
        this.m_Control.setControlType(ctype);
        this.updateToolTip();
    }

    public void synchronizeWithDevice() {
        this.updateToolTip();
    }

    private void updateToolTip() {
        int ctlType = this.m_Control.getControlType();
        String ctlNum = ctlType != 2 ? " #" + this.m_Control.getControlNum() : "";
        this.setToolTipText("Channel " + this.m_Control.getChannel() + ", " + FeenaDevice.getDisplayedControlType(ctlType) + ctlNum);
    }

    private void translateLocation(int x, int y, int dx, int dy) {
        this.setLocation(x - dx, y - dy);
        this.setSize(dx << 1, dy << 1);
    }

    public void mouseClicked(MouseEvent e) {
        FrontPanel fp = (FrontPanel)this.getParent();
        fp.setCurrentFrontPanelControl(this);
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }
}

