/*
 * Decompiled with CFR 0.152.
 */
package feenamiditweaker;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.SysexMessage;
import javax.sound.midi.Transmitter;

public class FeenaDevice
implements Receiver {
    public static FeenaDevice s_FeenaDevice;
    public static final String[] CONTROL_TYPE_NAMES;
    private static final int NUM_CONTROLS = 91;
    private static final int MIDI_MAP_SIZE = 100;
    private static final int TIMEOUT = 3000;
    private Control[] m_Controls = new Control[100];
    MidiDevice m_TransmitDevice = null;
    private Transmitter m_MIDIIn = null;
    MidiDevice m_ReceiveDevice = null;
    private Receiver m_MIDIOut = null;
    private boolean m_gotAck;
    private boolean m_gotNack;
    private int m_MidiBufferIndex = 0;
    private byte[] m_MidiBuffer = null;
    private boolean m_IsOutOfSync = true;
    private boolean m_IsEdited = true;
    private boolean m_isOnline = false;
    private static final int[] m_DefaultMidiMap;

    public static FeenaDevice getInstance() {
        return s_FeenaDevice;
    }

    public static void InitFeenaDevice() {
        s_FeenaDevice = new FeenaDevice();
    }

    public static String getDisplayedControlType(int i) {
        return CONTROL_TYPE_NAMES[i];
    }

    public FeenaDevice() {
        for (int i = 0; i < 100; ++i) {
            this.m_Controls[i] = new Control();
        }
        this.loadFile(m_DefaultMidiMap);
        if (this.openMIDIConnections()) {
            this.getFromDevice();
            this.m_isOnline = true;
        } else {
            this.m_isOnline = false;
        }
    }

    public boolean isEdited() {
        return this.m_IsEdited;
    }

    public boolean isOutOfSync() {
        return this.m_IsOutOfSync;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFromFile(File file) throws IOException {
        int[] tempArray = new int[100];
        FileInputStream in = null;
        try {
            int d;
            int c;
            in = new FileInputStream(file);
            int i = 0;
            while ((c = in.read()) != -1 && (d = in.read()) != -1 && i < tempArray.length) {
                tempArray[i++] = c << 8 | d;
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        this.loadFile(tempArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToFile(File file) throws FileNotFoundException, IOException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            for (int i = 0; i < this.m_Controls.length; ++i) {
                int outWord = this.m_Controls[i].getFileWord();
                out.write((byte)(outWord >> 8));
                out.write((byte)(outWord & 0xFF));
            }
            this.m_IsEdited = false;
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public Control getControlData(int index) {
        return this.m_Controls[index];
    }

    public void setAllChannels(int chnl) {
        for (int i = 0; i < this.m_Controls.length; ++i) {
            if (this.m_Controls[i].getControlType() == 2) continue;
            this.m_Controls[i].setChannel(chnl);
        }
    }

    public boolean findDevice() {
        boolean isOkay;
        boolean bl = isOkay = this.isConnected() && this.pingDevice();
        if (!isOkay) {
            this.closeMIDIConnections();
            isOkay = this.openMIDIConnections();
        }
        return isOkay;
    }

    public void closeDevice() {
        if (this.isOnline()) {
            byte[] dataArray = new byte[]{18, 0};
            this.sendSysexMessage(dataArray, 2, 3000);
            this.closeMIDIConnections();
        }
    }

    public boolean isOnline() {
        return this.isConnected();
    }

    public void isOnline(boolean isOnline) {
        this.m_isOnline = isOnline;
    }

    private boolean openMIDIConnections() {
        boolean gotTx = false;
        boolean gotRx = false;
        MidiDevice.Info[] info = MidiSystem.getMidiDeviceInfo();
        String oSName = System.getProperty("os.name").toLowerCase();
        if (oSName.startsWith("mac os x")) {
            for (int i = 0; !(i >= info.length || gotTx && gotRx); ++i) {
                MidiDevice.Info temp = info[i];
                if (!temp.getVendor().equals("Feena Elct.")) continue;
                try {
                    int txCt;
                    int rxCt;
                    MidiDevice dev = MidiSystem.getMidiDevice(temp);
                    if (!gotRx && (rxCt = dev.getMaxReceivers()) > 0) {
                        dev.open();
                        this.m_ReceiveDevice = dev;
                        gotRx = true;
                        this.m_MIDIOut = dev.getReceiver();
                    }
                    if (gotTx || (txCt = dev.getMaxTransmitters()) <= 0) continue;
                    if (dev != this.m_ReceiveDevice) {
                        dev.open();
                    }
                    this.m_TransmitDevice = dev;
                    gotTx = true;
                    this.m_MIDIIn = dev.getTransmitter();
                    this.m_MIDIIn.setReceiver(this);
                    continue;
                }
                catch (MidiUnavailableException ex) {
                    ex.printStackTrace();
                }
            }
        } else if (oSName.startsWith("windows")) {
            for (int i = 0; !(i >= info.length || gotTx && gotRx); ++i) {
                MidiDevice.Info devInfo1 = info[i];
                if (!devInfo1.getName().startsWith("USB Audio Device")) continue;
                String deviceName = devInfo1.getName();
                try {
                    MidiDevice rxDev;
                    int rxCt;
                    if (this.m_ReceiveDevice != null) {
                        this.m_ReceiveDevice.close();
                        gotRx = false;
                    }
                    if (!gotRx && (rxCt = (rxDev = MidiSystem.getMidiDevice(devInfo1)).getMaxReceivers()) != 0) {
                        rxDev.open();
                        this.m_ReceiveDevice = rxDev;
                        gotRx = true;
                        this.m_MIDIOut = rxDev.getReceiver();
                    }
                    for (int j = 0; !(j >= info.length || gotTx && gotRx); ++j) {
                        int txCt;
                        MidiDevice dev;
                        MidiDevice.Info devInfo2 = info[j];
                        if (!devInfo2.getName().equals(deviceName) || gotTx || (dev = MidiSystem.getMidiDevice(devInfo2)) == this.m_ReceiveDevice || (txCt = dev.getMaxTransmitters()) == 0) continue;
                        dev.open();
                        this.m_TransmitDevice = dev;
                        gotTx = true;
                        this.m_MIDIIn = dev.getTransmitter();
                        this.m_MIDIIn.setReceiver(this);
                    }
                    if (!gotTx || !gotRx || this.pingDevice()) continue;
                    gotRx = false;
                    gotTx = false;
                    this.closeMIDIConnections();
                    continue;
                }
                catch (MidiUnavailableException ex) {
                    ex.printStackTrace();
                }
            }
        }
        this.pingDevice();
        return this.pingDevice();
    }

    private void closeMIDIConnections() {
        if (this.m_MIDIOut != null) {
            this.m_MIDIOut.close();
        }
        this.m_MIDIOut = null;
        if (this.m_MIDIIn != null) {
            this.m_MIDIIn.close();
        }
        this.m_MIDIIn = null;
        if (this.m_TransmitDevice != null && this.m_TransmitDevice != this.m_ReceiveDevice) {
            this.m_TransmitDevice.close();
        }
        this.m_TransmitDevice = null;
        if (this.m_ReceiveDevice != null) {
            this.m_ReceiveDevice.close();
        }
        this.m_ReceiveDevice = null;
    }

    private boolean isConnected() {
        return this.m_MIDIIn != null && this.m_MIDIOut != null && this.m_isOnline;
    }

    public boolean getFromDevice() {
        boolean success;
        this.m_MidiBuffer = new byte[200];
        this.m_MidiBufferIndex = 0;
        boolean timeout = false;
        int debugTest = 0;
        byte[] dataArray = new byte[]{53, 0};
        if (this.sendSysexMessage(dataArray, 2, 3000)) {
            int ct = 0;
            while (this.m_MidiBufferIndex < 100 && !timeout) {
                ++debugTest;
                try {
                    Thread.sleep(100L);
                    timeout = this.m_MidiBufferIndex == ct;
                    ct = this.m_MidiBufferIndex;
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
            }
        }
        boolean bl = success = this.m_MidiBufferIndex >= 91;
        if (success) {
            for (int i = 0; i < this.m_MidiBufferIndex; ++i) {
                int j = i << 1;
                this.m_Controls[i].setControlNum(this.m_MidiBuffer[j++]);
                this.m_Controls[i].setRawControlType(this.m_MidiBuffer[j] & 7);
                this.m_Controls[i].setChannel((this.m_MidiBuffer[j] >> 3) + 1);
            }
            this.m_IsOutOfSync = false;
        }
        this.m_MidiBuffer = null;
        return success;
    }

    public void restoreDefaults() {
        this.loadFile(m_DefaultMidiMap);
    }

    public boolean sendToDevice() {
        byte[] outData = new byte[6];
        if (!this.pingDevice()) {
            return false;
        }
        for (int i = 0; i < 91; ++i) {
            outData[0] = 35;
            outData[1] = 96;
            outData[2] = (byte)(i * 2 + 6);
            outData[3] = (byte)this.m_Controls[i].getControlNum();
            outData[4] = (byte)(this.m_Controls[i].getChannel() - 1 << 3 | this.m_Controls[i].getRawControlType());
            if (this.sendSysexMessage(outData, 5, 3000)) continue;
            return false;
        }
        this.m_IsOutOfSync = false;
        return true;
    }

    private boolean pingDevice() {
        byte[] dataArray = new byte[]{17, 17};
        return this.sendSysexMessage(dataArray, 2, 3000);
    }

    private boolean sendSysexMessage(byte[] data1, int size, int elTime) {
        if (this.m_MIDIOut == null) {
            return false;
        }
        byte[] outData = new byte[size + 3];
        outData[0] = -16;
        outData[1] = 125;
        for (int i = 0; i < size; ++i) {
            outData[i + 2] = data1[i];
        }
        outData[size + 2] = -9;
        SysexMessage msg = new SysexMessage();
        try {
            msg.setMessage(outData, size + 3);
        }
        catch (InvalidMidiDataException ex) {
            ex.printStackTrace();
        }
        this.m_gotNack = false;
        this.m_gotAck = false;
        this.m_MIDIOut.send(msg, -1L);
        while (!this.m_gotAck && !this.m_gotNack && elTime > 0) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
            elTime -= 10;
        }
        return this.m_gotAck;
    }

    public void send(MidiMessage message, long timeStamp) {
        int len = message.getLength();
        byte[] buffer = message.getMessage();
        if (buffer[0] == -16 && buffer[1] == 125) {
            if (buffer[2] == 51 && buffer[3] == 68) {
                this.m_gotAck = true;
            }
            if (buffer[2] == 119 && buffer[3] == 68) {
                this.m_gotNack = true;
            }
            if (buffer[2] == 85 && this.m_MidiBuffer != null) {
                int j = this.m_MidiBufferIndex << 1;
                this.m_MidiBuffer[j] = buffer[3];
                this.m_MidiBuffer[j + 1] = buffer[4];
                ++this.m_MidiBufferIndex;
            }
        }
    }

    public void close() {
    }

    private void loadFile(int[] tempArray) {
        for (int i = 0; i < this.m_Controls.length && i < tempArray.length; ++i) {
            this.m_Controls[i].setFileWord(tempArray[i]);
        }
        this.m_IsEdited = false;
        this.m_IsOutOfSync = true;
    }

    static {
        CONTROL_TYPE_NAMES = new String[]{"CC", "Note", "Pitch Bend"};
        m_DefaultMidiMap = new int[]{144, 120, 124, 128, 104, 108, 112, 28, 168, 152, 156, 160, 148, 132, 136, 140, 196, 192, 188, 184, 180, 176, 172, 164, 100, 12, 28, 116, 112, 212, 200, 224, 228, 204, 220, 216, 208, 20, 16, 44, 24, 0, 4, 8, 176, 64, 60, 56, 52, 48, 32, 36, 40, 88, 92, 96, 80, 84, 72, 76, 68, 1, 5, 9, 13, 57, 49, 41, 33, 77, 85, 43, 559, 89, 65, 101, 25, 17, 21, 29, 61, 45, 53, 37, 81, 97, 1127, 1643, 93, 69, 73, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    public class Control {
        public static final int kCCControlType = 0;
        public static final int kNoteControlType = 1;
        public static final int kPitchBendControlType = 2;
        private int m_Channel;
        private int m_ControlNum;
        private int m_ControlType;

        public int getChannel() {
            return this.m_Channel;
        }

        public void setChannel(int ch) {
            this.m_Channel = ch;
            FeenaDevice.this.m_IsOutOfSync = (FeenaDevice.this.m_IsEdited = true);
        }

        public int getControlNum() {
            return this.m_ControlNum;
        }

        public void setControlNum(int cnum) {
            this.m_ControlNum = cnum;
            FeenaDevice.this.m_IsOutOfSync = (FeenaDevice.this.m_IsEdited = true);
        }

        public int getControlType() {
            return this.m_ControlType;
        }

        public void setControlType(int ctype) {
            this.m_ControlType = ctype;
            FeenaDevice.this.m_IsOutOfSync = (FeenaDevice.this.m_IsEdited = true);
        }

        private int getRawControlType() {
            if (this.m_ControlType == 2) {
                return 3;
            }
            if (this.m_ControlType == 0) {
                return 1;
            }
            return 0;
        }

        private void setRawControlType(int ctype) {
            this.m_ControlType = ctype == 3 ? 2 : (ctype == 1 ? 0 : 1);
        }

        private int getFileWord() {
            return this.m_Channel - 1 << 9 | this.m_ControlNum << 2 | this.getRawControlType();
        }

        private void setFileWord(int fWord) {
            this.m_Channel = (fWord >> 9 & 0xF) + 1;
            this.m_ControlNum = fWord >> 2 & 0x7F;
            this.setRawControlType(fWord & 3);
        }
    }
}

