/*
 * Decompiled with CFR 0.152.
 */
package feenamiditweaker;

import feenamiditweaker.FeenaDevice;
import feenamiditweaker.FrontPanel;
import feenamiditweaker.FrontPanelControl;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import org.jdesktop.layout.GroupLayout;

public class MIDITweaker
extends JFrame {
    private JFileChooser m_FileChooser;
    private File m_File = null;
    private FrontPanelControl m_CurrentControl = null;
    private static Color s_Olive = new Color(64, 192, 64);
    private static Color s_Brick = new Color(192, 64, 64);
    private JButton allChannelButton;
    private JSpinner cCNoteNumberControl;
    private JLabel cCNoteNumberLabel;
    private JSpinner channelControl;
    private JLabel channelLabel;
    private JLabel devStatusControl;
    private JLabel devStatusLabel;
    private JPanel editorPanel;
    private JPanel frontPanel;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator4;
    private JMenuItem m_AboutItem;
    private JMenu m_DeviceMenu;
    private JMenu m_FileMenu;
    private JMenuItem m_FileOpen;
    private JMenuItem m_FileSave;
    private JMenuItem m_FileSaveAs;
    private JMenuItem m_FindFeenaDevice;
    private JMenu m_HelpMenu;
    private JMenuItem m_RestoreDefaults;
    private JMenuItem m_SaveToDevice;
    private JComboBox messageTypeControl;
    private JLabel messageTypeLabel;
    private JButton storeButton;
    private JMenuBar tweakerMenuBar;

    public MIDITweaker() {
        FeenaDevice.InitFeenaDevice();
        this.m_FileChooser = new JFileChooser();
        this.m_FileChooser.setFileFilter(new FeenaFileFilter());
        this.initComponents();
        this.setCurrentFrontPanelControl(null);
        boolean isOnline = FeenaDevice.getInstance().isOnline();
        this.setDevicePresent(isOnline);
        if (!isOnline) {
            JOptionPane.showMessageDialog(this, "Feena Device was not found. Please plug it in and restart this program.");
        }
    }

    private void initComponents() {
        this.editorPanel = new JPanel();
        this.devStatusLabel = new JLabel();
        this.devStatusControl = new JLabel();
        this.channelLabel = new JLabel();
        this.messageTypeLabel = new JLabel();
        this.cCNoteNumberLabel = new JLabel();
        this.allChannelButton = new JButton();
        this.messageTypeControl = new JComboBox();
        this.channelControl = new JSpinner();
        this.cCNoteNumberControl = new JSpinner();
        this.storeButton = new JButton();
        this.frontPanel = new FrontPanel();
        this.tweakerMenuBar = new JMenuBar();
        this.m_FileMenu = new JMenu();
        this.m_FileOpen = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.m_FileSave = new JMenuItem();
        this.m_FileSaveAs = new JMenuItem();
        this.jSeparator2 = new JSeparator();
        this.m_RestoreDefaults = new JMenuItem();
        this.m_DeviceMenu = new JMenu();
        this.m_FindFeenaDevice = new JMenuItem();
        this.jSeparator4 = new JSeparator();
        this.m_SaveToDevice = new JMenuItem();
        this.m_HelpMenu = new JMenu();
        this.m_AboutItem = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                MIDITweaker.this.formWindowClosing(evt);
            }
        });
        this.devStatusLabel.setText("Device Status:");
        this.devStatusControl.setText("On Line");
        this.channelLabel.setText("Channel:");
        this.messageTypeLabel.setText("Type:");
        this.cCNoteNumberLabel.setText("CC:");
        this.allChannelButton.setText("All");
        this.allChannelButton.setToolTipText("Set all controls to the selected channel");
        this.allChannelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MIDITweaker.this.allChannelButtonActionPerformed(evt);
            }
        });
        this.messageTypeControl.setModel(new DefaultComboBoxModel<String>(new String[]{"CC", "Note", "Pitch Bend"}));
        this.messageTypeControl.setToolTipText("Set MIDI message type for the selected control");
        this.messageTypeControl.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MIDITweaker.this.messageTypeControlActionPerformed(evt);
            }
        });
        this.channelControl.setModel(new SpinnerNumberModel(1, 1, 16, 1));
        this.channelControl.setToolTipText("Set MIDI channel for the selected control");
        this.channelControl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                MIDITweaker.this.channelControlStateChanged(evt);
            }
        });
        this.cCNoteNumberControl.setModel(new SpinnerNumberModel(0, 0, 127, 1));
        this.cCNoteNumberControl.setToolTipText("Set MIDI control or note number for the selected control");
        this.cCNoteNumberControl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                MIDITweaker.this.cCNoteNumberControlStateChanged(evt);
            }
        });
        this.storeButton.setText("Save to Device");
        this.storeButton.setToolTipText("Transmit all settings to the device");
        this.storeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MIDITweaker.this.storeButtonActionPerformed(evt);
            }
        });
        GroupLayout editorPanelLayout = new GroupLayout((Container)this.editorPanel);
        this.editorPanel.setLayout((LayoutManager)editorPanelLayout);
        editorPanelLayout.setHorizontalGroup((GroupLayout.Group)editorPanelLayout.createParallelGroup(1).add((GroupLayout.Group)editorPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)editorPanelLayout.createParallelGroup(1).add((GroupLayout.Group)editorPanelLayout.createSequentialGroup().add((GroupLayout.Group)editorPanelLayout.createParallelGroup(2).add(1, (GroupLayout.Group)editorPanelLayout.createSequentialGroup().add((Component)this.devStatusLabel).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.devStatusControl)).add(1, (GroupLayout.Group)editorPanelLayout.createSequentialGroup().add((Component)this.channelLabel).addPreferredGap(0, 59, Short.MAX_VALUE).add((Component)this.channelControl, -2, -1, -2)).add(1, (GroupLayout.Group)editorPanelLayout.createSequentialGroup().add((Component)this.messageTypeLabel).addPreferredGap(0, 6, Short.MAX_VALUE).add((Component)this.messageTypeControl, -2, -1, -2)).add(1, (GroupLayout.Group)editorPanelLayout.createSequentialGroup().add((Component)this.cCNoteNumberLabel).addPreferredGap(0, 92, Short.MAX_VALUE).add((Component)this.cCNoteNumberControl, -2, -1, -2))).addPreferredGap(0).add((Component)this.allChannelButton, -2, 56, -2)).add((GroupLayout.Group)editorPanelLayout.createSequentialGroup().add((Component)this.storeButton, -1, 207, Short.MAX_VALUE).add(3, 3, 3)))));
        editorPanelLayout.setVerticalGroup((GroupLayout.Group)editorPanelLayout.createParallelGroup(1).add((GroupLayout.Group)editorPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)editorPanelLayout.createParallelGroup(3).add((Component)this.devStatusLabel).add((Component)this.devStatusControl)).add(32, 32, 32).add((GroupLayout.Group)editorPanelLayout.createParallelGroup(3).add((Component)this.channelLabel).add((Component)this.allChannelButton).add((Component)this.channelControl, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)editorPanelLayout.createParallelGroup(3).add((Component)this.messageTypeLabel).add((Component)this.messageTypeControl, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)editorPanelLayout.createParallelGroup(3).add((Component)this.cCNoteNumberLabel).add((Component)this.cCNoteNumberControl, -2, -1, -2)).addPreferredGap(0, 149, Short.MAX_VALUE).add((Component)this.storeButton)));
        this.frontPanel.setMaximumSize(new Dimension(488, 336));
        this.frontPanel.setMinimumSize(new Dimension(488, 336));
        this.frontPanel.setPreferredSize(new Dimension(488, 336));
        GroupLayout frontPanelLayout = new GroupLayout((Container)this.frontPanel);
        this.frontPanel.setLayout((LayoutManager)frontPanelLayout);
        frontPanelLayout.setHorizontalGroup((GroupLayout.Group)frontPanelLayout.createParallelGroup(1).add(0, 488, Short.MAX_VALUE));
        frontPanelLayout.setVerticalGroup((GroupLayout.Group)frontPanelLayout.createParallelGroup(1).add(0, 336, Short.MAX_VALUE));
        this.m_FileMenu.setText("File");
        this.m_FileOpen.setMnemonic('O');
        this.m_FileOpen.setText("Open");
        this.m_FileOpen.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MIDITweaker.this.m_FileOpenActionPerformed(evt);
            }
        });
        this.m_FileMenu.add(this.m_FileOpen);
        this.m_FileMenu.add(this.jSeparator1);
        this.m_FileSave.setText("Save");
        this.m_FileSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MIDITweaker.this.m_FileSaveActionPerformed(evt);
            }
        });
        this.m_FileMenu.add(this.m_FileSave);
        this.m_FileSaveAs.setText("Save As...");
        this.m_FileSaveAs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MIDITweaker.this.m_FileSaveAsActionPerformed(evt);
            }
        });
        this.m_FileMenu.add(this.m_FileSaveAs);
        this.m_FileMenu.add(this.jSeparator2);
        this.m_RestoreDefaults.setText("Restore Device Defaults");
        this.m_RestoreDefaults.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MIDITweaker.this.m_RestoreDefaultsActionPerformed(evt);
            }
        });
        this.m_FileMenu.add(this.m_RestoreDefaults);
        this.tweakerMenuBar.add(this.m_FileMenu);
        this.m_DeviceMenu.setText("Device");
        this.m_FindFeenaDevice.setText("Find Feena Device");
        this.m_FindFeenaDevice.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MIDITweaker.this.m_FindFeenaDeviceActionPerformed(evt);
            }
        });
        this.m_DeviceMenu.add(this.m_FindFeenaDevice);
        this.m_DeviceMenu.add(this.jSeparator4);
        this.m_SaveToDevice.setText("Save to Device");
        this.m_SaveToDevice.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MIDITweaker.this.m_SaveToDeviceActionPerformed(evt);
            }
        });
        this.m_DeviceMenu.add(this.m_SaveToDevice);
        this.tweakerMenuBar.add(this.m_DeviceMenu);
        this.m_HelpMenu.setText("Help");
        this.m_AboutItem.setText("About MIDITweaker...");
        this.m_AboutItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MIDITweaker.this.m_AboutItemActionPerformed(evt);
            }
        });
        this.m_HelpMenu.add(this.m_AboutItem);
        this.tweakerMenuBar.add(this.m_HelpMenu);
        this.setJMenuBar(this.tweakerMenuBar);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.frontPanel, -2, -1, -2).addPreferredGap(0).add((Component)this.editorPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.editorPanel, -1, -1, Short.MAX_VALUE).add((Component)this.frontPanel, -2, -1, -2)).addContainerGap()));
        this.pack();
    }

    private void formWindowClosed() {
    }

    private void formWindowClosing(WindowEvent evt) {
        FeenaDevice dev = FeenaDevice.getInstance();
        if (dev.isOnline() && dev.isOutOfSync()) {
            int conf = JOptionPane.showConfirmDialog(this, "Changes have not been saved to the device. Do it now?", "MIDITweaker is Closing", 0, 2);
            if (conf == 0) {
                dev.sendToDevice();
            } else if (conf == 2) {
                return;
            }
        }
        if (dev.isEdited()) {
            // empty if block
        }
        dev.closeDevice();
    }

    private void storeButtonActionPerformed(ActionEvent evt) {
        this.sendToDevice();
    }

    private void cCNoteNumberControlStateChanged(ChangeEvent evt) {
        SpinnerNumberModel model = (SpinnerNumberModel)this.cCNoteNumberControl.getModel();
        Number num = model.getNumber();
        if (this.m_CurrentControl != null && this.m_CurrentControl.getControlNum() != num.intValue()) {
            this.m_CurrentControl.setControlNum(num.intValue());
        }
    }

    private void m_AboutItemActionPerformed(ActionEvent evt) {
        JOptionPane.showMessageDialog(this, "Feena MIDITweaker\ncopyright 2006, Feena Electronics, LLC", "About MIDITweaker", 1);
    }

    private void m_FindFeenaDeviceActionPerformed(ActionEvent evt) {
        boolean isPresent = FeenaDevice.getInstance().findDevice();
        this.setDevicePresent(isPresent);
        if (isPresent) {
            if (FeenaDevice.getInstance().getFromDevice()) {
                this.synchronizeFrontPanelControls();
                FeenaDevice.getInstance().isOnline(true);
            } else {
                JOptionPane.showMessageDialog(this, "Error uploading data from the Feena FMDJ9303", "MIDITweaker: Find Device", 0);
                FeenaDevice.getInstance().isOnline(false);
            }
        } else {
            JOptionPane.showMessageDialog(this, "Could not find the Feena FMDJ9303", "MIDITweaker: Find Device", 0);
            FeenaDevice.getInstance().isOnline(false);
        }
    }

    private void m_RestoreDefaultsActionPerformed(ActionEvent evt) {
        FeenaDevice.getInstance().restoreDefaults();
        this.m_File = null;
        this.synchronizeFrontPanelControls();
    }

    private void m_SaveToDeviceActionPerformed(ActionEvent evt) {
        this.sendToDevice();
    }

    private void m_FileSaveAsActionPerformed(ActionEvent evt) {
        this.saveAs();
    }

    private void m_FileSaveActionPerformed(ActionEvent evt) {
        this.save();
    }

    private void m_FileOpenActionPerformed(ActionEvent evt) {
        int returnVal = this.m_FileChooser.showOpenDialog(this);
        if (returnVal == 0) {
            File file = this.m_FileChooser.getSelectedFile();
            boolean isOK = false;
            try {
                FeenaDevice.getInstance().readFromFile(file);
                this.m_File = file;
                this.synchronizeFrontPanelControls();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void channelControlStateChanged(ChangeEvent evt) {
        SpinnerNumberModel model = (SpinnerNumberModel)this.channelControl.getModel();
        Number num = model.getNumber();
        if (this.m_CurrentControl != null && this.m_CurrentControl.getChannel() != num.intValue()) {
            this.m_CurrentControl.setChannel(num.intValue());
        }
    }

    private void messageTypeControlActionPerformed(ActionEvent evt) {
        if (this.m_CurrentControl != null && this.m_CurrentControl.getControlType() != this.messageTypeControl.getSelectedIndex()) {
            this.m_CurrentControl.setControlType(this.messageTypeControl.getSelectedIndex());
        }
        this.adjustToCurrentMessageType();
    }

    private void allChannelButtonActionPerformed(ActionEvent evt) {
        int conf = JOptionPane.showConfirmDialog(this, "Change the channel of every control in the device except Pitch Bends to channel " + this.m_CurrentControl.getChannel() + "?", "MIDITweaker: Set All Channels", 0, 2);
        if (conf == 0) {
            FeenaDevice.getInstance().setAllChannels(this.m_CurrentControl.getChannel());
            this.synchronizeFrontPanelControls();
        }
    }

    private void save() {
        if (this.m_File == null || !this.m_File.canWrite()) {
            this.saveAs();
        }
        try {
            FeenaDevice.getInstance().saveToFile(this.m_File);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void saveAs() {
        int returnVal = this.m_FileChooser.showSaveDialog(this);
        if (returnVal == 0) {
            File file = this.m_FileChooser.getSelectedFile();
            if (!file.getName().endsWith(".fem")) {
                file = new File(file.getAbsoluteFile() + ".fem");
            }
            if (file.exists()) {
                int conf = JOptionPane.showConfirmDialog(this, "File already exists, are you sure you want to overwrite it?", "MIDITweaker: Overwrite File?", 0, 2);
                if (conf == 0) {
                    try {
                        FeenaDevice.getInstance().saveToFile(file);
                        this.m_File = file;
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            } else {
                try {
                    FeenaDevice.getInstance().saveToFile(file);
                    this.m_File = file;
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private void sendToDevice() {
        FeenaDevice dev = FeenaDevice.getInstance();
        boolean isOK = dev.isOnline();
        if (isOK) {
            isOK = dev.sendToDevice();
        }
        if (!isOK) {
            JOptionPane.showMessageDialog(this, "Error sending data to the Feena FMDJ9303", "MIDITweaker: Save to Device", 0);
            this.setDevicePresent(false);
        }
    }

    private void setDevicePresent(boolean present) {
        this.m_FileOpen.setEnabled(true);
        this.m_FileSave.setEnabled(true);
        this.m_FileSaveAs.setEnabled(true);
        this.m_SaveToDevice.setEnabled(present);
        this.m_RestoreDefaults.setEnabled(present);
        this.storeButton.setEnabled(present);
        if (present) {
            this.devStatusControl.setText("On Line");
            this.devStatusControl.setForeground(s_Olive);
        } else {
            this.devStatusControl.setText("Off Line");
            this.devStatusControl.setForeground(s_Brick);
        }
    }

    public void setCurrentFrontPanelControl(FrontPanelControl ctl) {
        this.m_CurrentControl = ctl;
        if (ctl == null) {
            this.channelLabel.setVisible(false);
            this.channelControl.setVisible(false);
            this.allChannelButton.setVisible(false);
            this.messageTypeLabel.setVisible(false);
            this.messageTypeControl.setVisible(false);
            this.cCNoteNumberLabel.setVisible(false);
            this.cCNoteNumberControl.setVisible(false);
        } else {
            this.messageTypeControl.setSelectedIndex(this.m_CurrentControl.getControlType());
            Integer Channel2 = new Integer(this.m_CurrentControl.getChannel());
            this.channelControl.setValue(Channel2);
            this.cCNoteNumberControl.setValue(new Integer(this.m_CurrentControl.getControlNum()));
            this.channelLabel.setVisible(true);
            this.channelControl.setVisible(true);
            this.allChannelButton.setVisible(true);
            this.messageTypeLabel.setVisible(true);
            this.messageTypeControl.setVisible(true);
            this.adjustToCurrentMessageType();
        }
    }

    private void adjustToCurrentMessageType() {
        int i = this.messageTypeControl.getSelectedIndex();
        String typeText = this.messageTypeControl.getSelectedItem().toString();
        if (i == 2) {
            this.cCNoteNumberLabel.setVisible(false);
            this.cCNoteNumberControl.setVisible(false);
        } else {
            this.cCNoteNumberLabel.setText(typeText);
            this.cCNoteNumberLabel.setVisible(true);
            this.cCNoteNumberControl.setVisible(true);
            if (i == 0 || i == 1) {
                // empty if block
            }
        }
    }

    private void synchronizeFrontPanelControls() {
        ((FrontPanel)this.frontPanel).synchronizeFrontPanelControls();
        this.setCurrentFrontPanelControl(this.m_CurrentControl);
    }

    public static String getExtension(File f) {
        String ext = null;
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    public static void setExtension(File f, String ext) {
        if (ext.equals(MIDITweaker.getExtension(f))) {
            return;
        }
        String s = f.getName();
        s = s + "ext";
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new MIDITweaker().setVisible(true);
            }
        });
    }

    public class FeenaFileFilter
    extends FileFilter {
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String ext = MIDITweaker.getExtension(f);
            return ext != null && ext.equals("fem");
        }

        public String getDescription() {
            return "Feena Files";
        }
    }
}

